Attribute VB_Name = "MdlWave"
Option Explicit


Public Const pi = 3.14159265358979
Const CENTER_OFFSET As Single = 50
Const GRAPH_Y_POSI_OFFSET As Single = 0.8
Const GRAPH_Y_RATIO As Single = 1.054545

Public Const MEAS_MAX_ID As Integer = 0
Public Const MEAS_MIN_ID As Integer = 1
Public Const MEAS_0DG_ID As Integer = 2
Public Const MEAS_NUM As Integer = 3

Public Sub ReadCalData()
    '*** Read Calibration Data ****
    Call QryTracData(NaPID(BdId), TrCa1, 0, totalP - 1, cal1(0))      'Cal Data 1
    Call QryTracData(NaPID(BdId), TrCa2, 0, totalP - 1, cal2(0))      'Cal Data 2
    Call QryTracData(NaPID(BdId), TrCa3, 0, totalP - 1, cal3(0))      'Cal Data 3
End Sub

Public Function dblRound(ByVal dt As Double, ByVal div_dt As Double, adj_dt As Double) As Double
    Dim l As Long
    Dim tmp As Double

    If dt = 0 Then
        dblRound = dt
    Else
        l = Fix(dt / div_dt)
        tmp = dt / div_dt - CDbl(l)
        If tmp = 0 Or dt = dt / div_dt * div_dt Then
            dblRound = dt / div_dt
        Else
            dblRound = dt / div_dt + adj_dt
        End If
    End If
End Function

Public Function lngFindMax(sdt() As Single, n As Long) As Long
    Dim l As Long
    Dim max_dt As Single
    Dim max_pnt As Long
    
    max_pnt = 0
    max_dt = sdt(0)
    For l = 0 To n
        If max_dt < sdt(l) Then max_dt = sdt(l): max_pnt = l
    Next l
    
    lngFindMax = max_pnt
End Function

Public Function lngFindMin(sdt() As Single, n As Long) As Long
    Dim l As Long
    Dim min_dt As Single
    Dim min_pnt As Long
    
    min_pnt = 0
    min_dt = sdt(0)
    For l = 0 To n
        If min_dt > sdt(l) Then min_dt = sdt(l): min_pnt = l
    Next l
    
    lngFindMin = min_pnt
End Function

Public Function sngFind0Phase(sdt() As Single, n As Long) As Long
    Dim l As Long
    Dim before_dt As Single
    Dim after_dt As Single
    Dim pnt As Long
    
    pnt = -1
    
    For l = 0 To n - 1
        before_dt = sdt(l)
        after_dt = sdt(l + 1)
        If before_dt < after_dt Then
            If before_dt < 0 And 0 < after_dt Then pnt = l: Exit For
        Else
            If after_dt < 0 And 0 < before_dt Then pnt = l: Exit For
        End If
    Next l
    
    sngFind0Phase = pnt
End Function


Public Function lngSearchData(meas_id As Integer, meas_format As Integer, ByRef dblFreq) As Long
    Dim vvv As Double
    Dim fff As Double
    Dim ppp As Long
    Dim p1, p2 As Long
    Dim f1, f2 As Double
    Dim y As Single
    Dim p As Integer

    ppp = -1
    dblFreq = 0
    If meas_id = MEAS_MAX_ID Then
        If meas_format = FmtTypeDelay Then
            ppp = MaxPDelay
        ElseIf meas_format = FmtTypeSwr Then
            ppp = MaxPSwr
        ElseIf meas_format = FmtTypeLogMg Or meas_format = FmtTypePolar Or meas_format = FmtTypeSmith Then
            If intFileRecall = cnt_FILE_RECALL Then
                ppp = lngFindMax(BufLgm, totalP - 1)
            Else
                Call QryFetcMax(NaPID(BdId), TrLgm, 0, totalP - 1, vvv, fff, ppp)
            End If
        ElseIf meas_format = FmtTypeReal Then
            ppp = lngFindMax(BufReal, totalP - 1)
        ElseIf meas_format = FmtTypeImag Then
            ppp = lngFindMax(BufImag, totalP - 1)
        End If
    ElseIf meas_id = MEAS_MIN_ID Then
        If meas_format = FmtTypeDelay Then
            ppp = MinPDelay
        ElseIf meas_format = FmtTypeSwr Then
            ppp = MinPSwr
        ElseIf meas_format = FmtTypeLogMg Or meas_format = FmtTypePolar Or meas_format = FmtTypeSmith Then
            If intFileRecall = cnt_FILE_RECALL Then
                ppp = lngFindMin(BufLgm, totalP - 1)
            Else
                Call QryFetcMin(NaPID(BdId), TrLgm, 0, totalP - 1, vvv, fff, ppp)
            End If
        ElseIf meas_format = FmtTypeReal Then
            ppp = lngFindMin(BufReal, totalP - 1)
        ElseIf meas_format = FmtTypeImag Then
            ppp = lngFindMin(BufImag, totalP - 1)
        End If
    ElseIf meas_id = MEAS_0DG_ID Then
        ppp = sngFind0Phase(BufPhs, totalP - 1)
        If -1 < ppp Then
            f1 = BufFrq(ppp)
            f2 = BufFrq(ppp + 1)
            fff = f1 + (f2 - f1) * (0 - BufPhs(ppp) / (BufPhs(ppp + 1) - BufPhs(ppp)))
            lngSearchData = ppp
            dblFreq = fff
        Else
            lngSearchData = ppp
            dblFreq = BufFrq(0)
        End If
    Else
        lngSearchData = ppp
        dblFreq = BufFrq(ppp)
        Exit Function
    End If
    If -1 < ppp And dblFreq = 0 Then dblFreq = BufFrq(ppp)
    lngSearchData = ppp
End Function

'***********************************************************************************
' Scale limit calculation (Logmag & Phase)
'    Function SclLim() As Single
'    Argument ByVal mx As Single : Maximum value of scale to be displayed
'         ByRef mn As Single : Minimum value of scale to be displayed
'         ByRef vy As Single : Y direction offset
'         ByRef dy As Single : Y direction resolution ratio
'         ByRef dt As Single : Data
'
'    Return value : Display position
'***********************************************************************************
Public Function SclLim(ByVal mx As Single, ByVal mn As Single, ByVal vy As Single, _
                        ByVal dy As Single, ByVal dt As Single) As Single
    Dim hh As Single
    Dim ym As Single
    Dim yn As Single
    Dim dbltmp As Double

    '' Add a few dots to the upper and lower scale limits.
    hh = dy * (mx - mn)
    ym = hh * (-0.01)
    yn = hh * 1.01
    dbltmp = (CDbl(dy) * (CDbl(mx) - CDbl(dt)))
    If ym > dbltmp Then
        SclLim = ym
    ElseIf dbltmp > yn Then
        SclLim = yn
    Else
        SclLim = CSng(dbltmp)
    End If
    SclLim = vy + SclLim

End Function

Sub waveform_display(ByVal pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate, _
                        ByRef scl As Scale_t, ByVal Color As Long, ByRef Data() As Single)
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
    Dim ss As Single
    Dim Gsmax, Gsmin As Single
    Dim DeltY As Single
    Dim x1, y1, x2, y2 As Single
    Dim x1_pre, y1_pre, x2_pre, y2_pre As Single
    Dim i As Integer
    Dim po As Long
    Dim Ydata1 As Single
    
    On Error GoTo ErrLogmagOverflow

    '----------------------------------
    ' LOGMAG waveform
    '----------------------------------
    With GrphRect
        Grefv = scl.ref
        Gsdiv = scl.div
        Grefp = scl.pos
        StepSdiv = Gsdiv / 10
        ss = Abs(100 - Grefp)
        Gsmax = Grefv + (ss * StepSdiv)
        Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)
    
        'Calculating 
        ss = Gsmax - Gsmin
        If ss = 0 Then ss = Gsmin
        DeltY = (.ViewY * 10) / ss
        '
        Ydata1 = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, Data(0))
        pic.PSet (.ViewX, Ydata1)
        i = 0
        For po = 0 To .points
            Ydata1 = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, Data(i))
            pic.Line -(.DeltX * po + .ViewX, Ydata1), Color
            i = i + 1
        Next po
    End With
    
ErrLogmagEnd:
    On Error GoTo 0
    Exit Sub

ErrLogmagOverflow:
    MsgBox "Error Data Overflow" + vbCrLf + vbCrLf, vbOKOnly Or vbCritical
    GoTo ErrLogmagEnd

End Sub

Private Sub disp_message(ByRef pic As PictureBox, ByRef strMsg As String)
    Dim GrphRect As struct_Rectangular_coordinate
    
    If SwpTime < 2 Then Exit Sub
    '----------------------------------
    ' Message area display
    '----------------------------------
    With GrphRect
        .ViewX = pic.ScaleWidth / 104
        .ViewY = (pic.ScaleHeight) / 11
        .VYoff = GRAPH_Y_POSI_OFFSET
        pic.PSet (.ViewX, .ViewY * (2 + .VYoff))
        pic.Line (.ViewX * 89, .ViewY * (2.5 + .VYoff))-(.ViewX * (1.2 * 10 + 1), .ViewY * (1.5 + .VYoff)), vbBlack, BF
        Call frmMain.PicBoxMkrDisp(pic, .ViewX * (2.1 * 10 + 1), .ViewY * (1.8 + .VYoff), strMsg, 10, vbWhite)
    End With
End Sub

Public Sub Specified_disp_message(intFmtTab As Integer)
    
    If intFmtTab = FmtTypeLogMg Then
        Call disp_message(frmMain.PictBox_Logmag, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypePolar Then
        Call disp_message(frmMain.PictBox_POLAR, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypeSmith Then
        Call disp_message(frmMain.PictBox_Smith, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypeDelay Then
        Call disp_message(frmMain.PictBox_DELAY, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypeSwr Then
        Call disp_message(frmMain.PictBox_SWR, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypeReal Then
        Call disp_message(frmMain.PictBox_Real, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypeImag Then
        Call disp_message(frmMain.PictBox_Imag, WAIT_MESSAGE_01)
    ElseIf intFmtTab = FmtTypeOverlap Then
        Call disp_message(frmMain.PictBox_Overlap, WAIT_MESSAGE_01)
    End If

End Sub

Private Sub grid_display(ByRef pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate)
    Dim i As Integer
    Dim x1 As Single
    Dim y1 As Single
    Dim x2 As Single
    Dim y2 As Single
    
    pic.Cls
    pic.DrawStyle = 0  'Solid line specification
    '
    '----------------------------------
    ' Grid display
    '----------------------------------
    With GrphRect
        For i = 1 To 9
            If i <> 5 And i <> 10 Then
                pic.PSet (.ViewX, .ViewY * (i + .VYoff))
                pic.Line -(.ViewX * 101, .ViewY * (i + .VYoff)), .Color1
                pic.PSet (.ViewX * (i * 10 + 1), .ViewY * .VYoff)
                pic.Line -(.ViewX * (i * 10 + 1), .ViewY * (10 + .VYoff)), .Color1
            End If
        Next i
    
        For i = 0 To 10 Step 5
            pic.PSet (.ViewX, .ViewY * (i + .VYoff))
            pic.Line -(.ViewX * 101, .ViewY * (i + .VYoff)), .Color2
            pic.PSet (.ViewX * (i * 10 + 1), .ViewY * .VYoff)
            pic.Line -(.ViewX * (i * 10 + 1), .ViewY * (10 + .VYoff)), .Color2
        Next i
    
        pic.Line -(.ViewX * 101, .ViewY * 10), .Color2  ' Because the end point is not displayed.
    End With
End Sub

'**********************************************
Private Sub draw_grid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphRect As struct_Rectangular_coordinate, _
                        ByRef Color() As Long)
    
    'Calculates size of scale frame
    With GrphRect
        .points = pt - 1
        .ViewX = pic.ScaleWidth / 104
        .ViewY = (pic.ScaleHeight) / 11
        .VYoff = GRAPH_Y_POSI_OFFSET
        .DeltX = (.ViewX * 100) / .points
        .Color1 = Color(GRID_NORMAL)
        .Color2 = Color(GRID_BOLD)
    End With
    
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call grid_display(pic, GrphRect)

End Sub


'***********************************************************************************
' Reference marker display (Logmag & Phase)
'    Sub ref_mkr_display()
'    Argument ByRef pic As PictureBox : Object of the graph display
'         ByRef ViewX As Single   : Display area (X)
'         ByRef ViewY As Single   : Display area (Y)
'         ByRef VYoff As Single   : Offset in Y direction
'         ByRef Scale As Scale_t  : Scale value for LogMag/Phase
'         ByVal Color As Long     : Marker color specification
'***********************************************************************************
Private Sub ref_mkr_display(ByRef pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate, _
                    ByRef scl As Scale_t, ByVal Color As Long)
    Dim yy As Single
    
    '----------------------------------
    ' Reference mark  display
    '----------------------------------
    With GrphRect
        yy = .ViewY * (10 + .VYoff - scl.pos / 10)
        pic.PSet (.ViewX * 101, yy)
        pic.Line -(.ViewX * 103, yy - .ViewY * 0.15), Color
        pic.Line -(.ViewX * 103, yy + .ViewY * 0.15), Color
        pic.Line -(.ViewX * 101, yy), Color
    End With
End Sub


'***********************************************************************************
' ԏiԁj
'***********************************************************************************
Private Function x_mkr_interpolation(ByVal ActCh As Long, ByRef Rectinf As struct_Rectangular_coordinate, ByVal mp As Long, ByVal mkx As Double, ByRef Refx() As Double) As Single
    Dim xx As Single
    
    With Rectinf
        If mkx <> Refx(mp, ActCh) Then
            If mp <> 0 Then
                If Refx(mp - 1, ActCh) < mkx And mkx < Refx(mp, ActCh) Then mp = mp - 1
            End If
            If Refx(mp + 1, ActCh) - Refx(mp, ActCh) <> 0 Then
                mkx = mp + (mkx - Refx(mp, ActCh)) * ((mp + 1) - mp) / (Refx(mp + 1, ActCh) - Refx(mp, ActCh))
                xx = .DeltX * mkx + .ViewX
            Else
                xx = .DeltX * mp + .ViewX
            End If
        Else
            xx = .DeltX * mp + .ViewX
        End If
    End With
    
    x_mkr_interpolation = xx
End Function

'***********************************************************************************
' Marker display
'***********************************************************************************
Private Sub grph_mkr_mark_disp(ByRef pic As PictureBox, ByVal xx As Single, ByVal yy As Single, ByVal strMkr As String, ByVal Color As Long)
    Dim X As Single
    
    pic.PSet (xx, yy)

    For X = xx To xx - 50 Step -1
        pic.Line (xx, yy)-(X, yy - 150), Color
    Next X
    For X = xx To xx + 50 Step 1
        pic.Line (xx, yy)-(X, yy - 150), Color
    Next X
    Call frmMain.PicBoxMkrDisp(pic, xx - 30, yy - 350, strMkr, 8, Color) 'Marker No. display
End Sub

'***********************************************************************************
' marker display (Logmag & Phase)
'    Sub v_mkr_display()
'    Argument ByVRef pic As Graphics : Object of the graph display
'         ByVal ViewX As Single : Display area (X)
'         ByVal ViewY As Single : Display area (Y)
'         ByVal VYoff As Single : Offset in Y direction
'         ByVal DeltX As Single : Horizontal resolution
'         ByRef Data() As Single : Trace data.
'         ByRef scl As Scale_t : Scale.
'         ByVal points As Integer : Number of measurement points
'***********************************************************************************
Private Sub v_mkr_display(ByRef pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate, _
                            ByRef scl As Scale_t, ByRef Data() As Single)

'    Dim Grefv, Gsdiv, Grefp, StepSdiv As Single
'    Dim ss As Single
    Dim Grefv, Gsdiv, Grefp, StepSdiv As Double
    Dim ss As Double
    Dim Gsmax, Gsmin, dt As Single
    Dim DeltY As Single
    Dim xx As Single
    Dim yy As Single
    Dim Color As Long
    Dim k As Integer
    Dim StrMeasData As String
    Dim Y_line As Single
    Dim mp As Integer
    Dim mkr_frq As Double

    Grefv = scl.ref
    Gsdiv = scl.div
    Grefp = scl.pos
    StepSdiv = Gsdiv / 10
    ss = Abs(100 - Grefp)
    Gsmax = Grefv + (ss * StepSdiv)
    Gsmin = Grefv - (Abs(100 - ss) * StepSdiv)

    With GrphRect
        'Calculating 
        ss = CDbl(Gsmax) - CDbl(Gsmin)
        If ss = 0 Then ss = Gsmin
        DeltY = (.ViewY * 10) / ss
        '
        Y_line = 150    ' 1 Line Offset
        
        For k = 0 To MAX_MARKER
            mp = -1
            If Marker(BdId, ActCh(BdId), k).MkrDispFlag = MKR_DISPLAY Then
                mp = Marker(BdId, ActCh(BdId), k).MkrPoint
                If k = ActMkr Then
                    Color = MkrColor(MKR_COLOR___ACT)
                Else
                    Color = MkrColor(MKR_COLOR_NOACT)
                End If
                mkr_frq = Marker(BdId, ActCh(BdId), k).MkrFreq
                If BufFrq(mp) = mkr_frq Then
                    dt = Data(mp)
                    xx = .DeltX * mp + .ViewX
                    yy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, dt)
                Else
                    Call Get_X_Y_Interpolation(mp, mkr_frq, dt, BufFrq(), Data())
                    xx = .DeltX * mkr_frq + .ViewX
                    yy = SclLim(Gsmax, Gsmin, .ViewY * .VYoff, DeltY, dt)
                End If
                Call grph_mkr_mark_disp(pic, xx, yy, CStr(k + 1), Color) 'Marker display
            End If
        Next k
    End With
    
End Sub

Public Sub PicBoxTextDisp(ByRef pic As PictureBox, ByVal SngX As Single, ByVal SngY As Single, ByVal strWork As String, ByVal Color As Long)
    Dim obj As PictureBox

    Set obj = pic
    With obj
        .Font.Size = 8
        .Font.Name = "Arial"
        .ForeColor = Color
        .TextWidth strWork
        .CurrentX = SngX
        .CurrentY = SngY
        obj.Print strWork
    End With
    Set obj = Nothing
    
End Sub

'***********************************************************************************
' Vertical marker display (Logmag & Phase)
'    Sub mkr_list_display()
'    Argument ByVRef pic As Graphics : Object of the graph display
'         ByVal ViewX As Single : Display area (X)
'         ByVal ViewY As Single : Display area (Y)
'         ByVal VYoff As Single : Offset in Y direction
'         ByVal DeltX As Single : Horizontal resolution
'         ByRef Data() As Single : Trace data.
'         ByRef scl As Scale_t : Scale.
'         ByVal points As Integer : Number of measurement points
'***********************************************************************************
Private Sub mkr_list_display(ByRef pic As PictureBox, ByVal MemTrace As Integer, ByRef line_cnt As Integer, ByVal cntup As Integer, _
                    ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single)

    Dim k As Integer
    Dim StrMkrFreqData As String
    Dim StrMeasData As String
    Dim Y_line As Single
    
    If frmMain.Check_MkrList.Value = 0 Then Exit Sub
    
    Y_line = 150    ' 1 Line Offset
    
    For k = 0 To MAX_MARKER
        If Marker(BdId, ActCh(BdId), k).MkrDispFlag = MKR_DISPLAY Then
            ' *** Measurement marker list display ***
            If MemTrace = MEM_TRC_DSP_OFF Then
                StrMkrFreqData = "No." & Format(k + 1, "@@") & vbTab  '", Freq :"
                Call make_mkr_freq_list(pic, Y_line * line_cnt + 380, Marker(BdId, ActCh(BdId), k), StrMkrFreqData, MkrClrList(MKR_L_COLOR_ACT))
                Call make_mkr_level_list(pic, Y_line * line_cnt + 380, Marker(BdId, ActCh(BdId), k), _
                                            Data1(), Data2(), Data3(), StrMeasData, MkrClrList(MKR_L_COLOR_ACT))
            Else
                Call make_mkr_level_list(pic, Y_line * line_cnt + 380, Marker(BdId, ActCh(BdId), k), _
                                            Data1(), Data2(), Data3(), StrMeasData, MkrClrList(MKR_L_COLOR_MEM))
            End If
            line_cnt = line_cnt + cntup
            StrMeasData = ""
        End If
    Next k
       
End Sub



'***********************************************************************************
' Tracking marker display
'    Sub trk_mkr_display()
'    Argument ByVRef pic As Graphics : Object of the graph display
'         ByVal ViewX As Single : Display area (X)
'         ByVal ViewY As Single : Display area (Y)
'         ByVal VYoff As Single : Offset in Y direction
'         ByVal DeltX As Single : Horizontal resolution
'         ByRef Data() As Single : Trace data.
'         ByRef scl As Scale_t : Scale.
'         ByVal points As Integer : Number of measurement points
'***********************************************************************************

Private Sub trk_mkr_display(ByRef pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate, _
                            ByRef list_disp As Integer, ByRef scl As Scale_t, ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single)
    Dim maxp As Long
    Dim minp As Long
    Dim meas_format As Integer
    Dim max_min(MEAS_NUM) As structMkrInf
    Dim chkbx(MEAS_NUM) As Integer
    Dim mkr_list As Integer
    
    With frmMain.SSTab_DispFromat
        If .Tab = FmtTypeOverlap Then
            If frmMain.Check_Format(ChkTypeLogMg).Value = 1 Then
                meas_format = FmtTypeLogMg
            ElseIf frmMain.Check_Format(ChkTypeDelay).Value = 1 Then
                meas_format = FmtTypeDelay
            ElseIf frmMain.Check_Format(ChkTypeSwr).Value = 1 Then
                meas_format = FmtTypeSwr
            ElseIf frmMain.Check_Format(ChkTypeReal).Value = 1 Then
                meas_format = FmtTypeReal
            ElseIf frmMain.Check_Format(ChkTypeImag).Value = 1 Then
                meas_format = FmtTypeImag
            End If
            If list_disp = MKR_LIST_OFF Then
                mkr_list = frmMain.Check_Format(frmMain.Combo_MkrActFormat.ListIndex).Value
            Else
                mkr_list = MKR_LIST_OFF
            End If
        Else
            meas_format = .Tab
            If list_disp = MKR_LIST_OFF Then
                mkr_list = MKR_LIST__ON
            Else
                mkr_list = MKR_LIST_OFF
            End If
        End If
    End With

    If frmMain.Check_Tracking(MEAS_MAX_ID).Value = 1 Then   'Max Search
        max_min(MEAS_MAX_ID).MkrPoint = lngSearchData(MEAS_MAX_ID, meas_format, max_min(MEAS_MAX_ID).MkrFreq)
        chkbx(MEAS_MAX_ID) = 1
    End If
    
    If frmMain.Check_Tracking(MEAS_MIN_ID).Value = 1 Then   'Min Search
        max_min(MEAS_MIN_ID).MkrPoint = lngSearchData(MEAS_MIN_ID, meas_format, max_min(MEAS_MIN_ID).MkrFreq)
        chkbx(MEAS_MIN_ID) = 1
    End If
    
    If frmMain.SSTab_DispFromat.Tab = FmtTypeLogMg Or _
        (frmMain.SSTab_DispFromat.Tab = FmtTypeOverlap And frmMain.Check_Format(ChkTypeLogMg).Value = 1) Then
        If chkbx(MEAS_MAX_ID) = 0 And chkbx(MEAS_MIN_ID) = 0 Then Exit Sub
    Else
        If frmMain.Check_Tracking(MEAS_0DG_ID).Value = 1 Then   '0 Deg Search
            max_min(MEAS_0DG_ID).MkrPoint = lngSearchData(MEAS_0DG_ID, meas_format, max_min(MEAS_0DG_ID).MkrFreq)
            chkbx(MEAS_0DG_ID) = 1
        End If

        If chkbx(MEAS_MAX_ID) = 0 And chkbx(MEAS_MIN_ID) = 0 And chkbx(MEAS_0DG_ID) = 0 Then Exit Sub
    End If
    
    If max_min(MEAS_MAX_ID).MkrPoint < 0 Then max_min(MEAS_MAX_ID).MkrPoint = 0: max_min(MEAS_MAX_ID).MkrFreq = BufFrq(0)
    If max_min(MEAS_MIN_ID).MkrPoint < 0 Then max_min(MEAS_MIN_ID).MkrPoint = 0: max_min(MEAS_MIN_ID).MkrFreq = BufFrq(0)
    If max_min(MEAS_0DG_ID).MkrPoint < 0 Then max_min(MEAS_0DG_ID).MkrPoint = 0: max_min(MEAS_0DG_ID).MkrFreq = BufFrq(0)
    
    Call x_mkr_display(pic, GrphRect, scl, Data1, Data2, Data3, chkbx(), max_min(), mkr_list)
    
    If list_disp = MKR_LIST_OFF Then list_disp = mkr_list
    
End Sub

'***********************************************************************************
' Tracking 0deg marker display
'    Sub trk_0deg_mkr_display()
'    Argument ByVRef pic As Graphics : Object of the graph display
'         ByVal ViewX As Single : Display area (X)
'         ByVal ViewY As Single : Display area (Y)
'         ByVal VYoff As Single : Offset in Y direction
'         ByVal DeltX As Single : Horizontal resolution
'         ByRef Data() As Single : Trace data.
'         ByRef scl As Scale_t : Scale.
'         ByVal points As Integer : Number of measurement points
'***********************************************************************************
Private Sub trk_0deg_mkr_display(ByRef pic As PictureBox, ByRef GrphRect As struct_Rectangular_coordinate, _
                                 ByRef list_disp As Integer, ByRef scl As Scale_t, ByRef Data1() As Single, ByRef Data2() As Single, ByRef Data3() As Single)
    Dim maxp As Long
    Dim minp As Long
    Dim meas_format As Integer
    Dim max_min(MEAS_NUM) As structMkrInf
    Dim chkbx(MEAS_NUM) As Integer
    Dim mkr_list As Integer
    
    With frmMain.SSTab_DispFromat
        If .Tab = FmtTypeOverlap Then
            If frmMain.Check_Format(ChkTypeLogMg).Value = 1 Then
                meas_format = FmtTypeLogMg
            ElseIf frmMain.Check_Format(ChkTypeDelay).Value = 1 Then
                meas_format = FmtTypeDelay
            ElseIf frmMain.Check_Format(ChkTypeSwr).Value = 1 Then
                meas_format = FmtTypeSwr
            ElseIf frmMain.Check_Format(ChkTypeReal).Value = 1 Then
                meas_format = FmtTypeReal
            ElseIf frmMain.Check_Format(ChkTypeImag).Value = 1 Then
                meas_format = FmtTypeImag
            End If
            If list_disp = MKR_LIST_OFF Then
                mkr_list = frmMain.Check_Format(frmMain.Combo_MkrActFormat.ListIndex).Value
            Else
                mkr_list = MKR_LIST_OFF
            End If
        Else
            meas_format = .Tab
            If list_disp = MKR_LIST_OFF Then
                mkr_list = MKR_LIST__ON
            Else
                mkr_list = MKR_LIST_OFF
            End If
        End If
    End With

    If frmMain.Check_Tracking(MEAS_0DG_ID).Value = 1 Then '0Deg Search
        max_min(MEAS_0DG_ID).MkrPoint = lngSearchData(MEAS_0DG_ID, meas_format, max_min(MEAS_0DG_ID).MkrFreq)
        chkbx(MEAS_0DG_ID) = 2
    End If
    
    If chkbx(MEAS_0DG_ID) = 0 Then Exit Sub
    
    If max_min(MEAS_0DG_ID).MkrPoint < 0 Then max_min(MEAS_0DG_ID).MkrPoint = 0: max_min(MEAS_0DG_ID).MkrFreq = BufFrq(0)
    Call x_mkr_display(pic, GrphRect, scl, Data1, Data2, Data3, chkbx(), max_min(), mkr_list)
    
    If list_disp = MKR_LIST_OFF Then list_disp = mkr_list
        
End Sub

'***********************************************************************************
' Waveform and marker display
'    Sub draw_wave()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef buf1() As Single : Array data of LogMag value
'         ByRef buf2() As Single : Array data of Phase value
'         ByRef buf1_Pre() As Single : For the previous data to draw waveforms (LogMag value).
'         ByRef buf2_Pre() As Single : For the previous data to draw waveforms (Phase value).
'         ByRef pt As Integer : Number of measurement points
'         ByRef s1 As Scale_t : Scale value for LogMag
'         ByRef s2 As Scale_t : Scale value for Phase
'         ByRef tr2 As Integer F ON/OFF flag of Phase waveform
'         ByRef mk As Integer F Marker drawing flag
'***********************************************************************************
Public Sub draw_wave(ByRef pic As PictureBox, _
                ByRef buf1() As Single, ByRef buf2() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByRef s2 As Scale_t, _
                ByRef tr2 As Integer, _
                ByRef mk As Integer)
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim list_disp As Integer
    
    line_cnt = 1: cntup = 1
    
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_grid(pic, pt, GrphRect, GrdClrLogmag)
    
    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, GrphRect, s1, TrcClrLogmag)   ' Lognmag
    Call ref_mkr_display(pic, GrphRect, s2, TrcClrPhase)    ' Phase
    '----------------------------------
    ' LOGMAG waveform
    '----------------------------------
    Call waveform_display(pic, GrphRect, s1, TrcClrLogmag, buf1)

    '----------------------------------
    ' PHASE waveform
    '----------------------------------
    If tr2 = 1 Then
        Call waveform_display(pic, GrphRect, s2, TrcClrPhase, buf2)
    End If

    '----------------------------------
    ' Drawing current marker
    '----------------------------------
    If mk = 1 Then
        Call v_mkr_display(pic, GrphRect, s1, buf1)
        If tr2 = 1 Then
            Call v_mkr_display(pic, GrphRect, s2, buf2)
        End If
    End If
    
    Call trk_mkr_display(pic, GrphRect, list_disp, s1, buf1, buf2, BufLnm)
    If tr2 = 1 Then
        list_disp = MKR_LIST_OFF
        Call trk_0deg_mkr_display(pic, GrphRect, list_disp, s2, buf1, buf2, BufLnm)
    End If
    
    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, buf1, buf2, BufLnm)
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub


'***********************************************************************************
' Waveform and marker display
'    Sub draw_waveMem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef buf1() As Single : Array data of LogMag value
'         ByRef buf2() As Single : Array data of Phase value
'         ByRef buf1_Pre() As Single : For the previous data to draw waveforms (LogMag value).
'         ByRef buf2_Pre() As Single : For the previous data to draw waveforms (Phase value).
'         ByRef pt As Integer : Number of measurement points
'         ByRef s1 As Scale_t : Scale value for LogMag
'         ByRef s2 As Scale_t : Scale value for Phase
'         ByVal MemTrc () As structMemTraceChInf F Drawing memory trace.
'         ByRef tr2 As Integer F ON/OFF flag of Phase waveform
'         ByRef mk As Integer F Marker drawing flag
'***********************************************************************************
Public Sub draw_waveMem(ByRef pic As PictureBox, _
                ByRef buf1() As Single, ByRef buf2() As Single, ByRef buf3() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByRef s2 As Scale_t, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByRef tr2 As Integer, _
                ByRef mk As Integer)
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim list_disp As Integer

    line_cnt = 1: cntup = 1

    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_grid(pic, pt, GrphRect, GrdClrLogmag)
    
    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, GrphRect, s1, TrcClrLogmag)   ' Lognmag
    Call ref_mkr_display(pic, GrphRect, s2, TrcClrPhase)    ' Phase
    '----------------------------------
    ' LOGMAG waveform
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveform_display(pic, GrphRect, s1, .MemTrcLgmCol, .MemTrcBufLgm)
                End With
            End If
        Next tr
    End If
    Call waveform_display(pic, GrphRect, s1, TrcClrLogmag, buf1)
    
    '----------------------------------
    ' PHASE waveform
    '----------------------------------
    If tr2 = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
            For tr = 0 To MAX_MEMTRACE
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                    With ChMemTrc(BdId, ActCh(BdId), tr)
                        Call waveform_display(pic, GrphRect, s2, .MemTrcPhsCol, .MemTrcBufPhs)
                    End With
                End If
            Next tr
        End If
        Call waveform_display(pic, GrphRect, s2, TrcClrPhase, buf2)
    End If

    '----------------------------------
    ' Drawing current marker
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call v_mkr_display(pic, GrphRect, s1, .MemTrcBufLgm)
            End With
        End If
        Call v_mkr_display(pic, GrphRect, s1, buf1)
        
        If tr2 = 1 Then
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                    Call v_mkr_display(pic, GrphRect, s2, .MemTrcBufPhs)
                End With
            End If
            Call v_mkr_display(pic, GrphRect, s2, buf2)
        End If
    End If
    
    Call trk_mkr_display(pic, GrphRect, list_disp, s1, buf1, buf2, buf3)
    
    If tr2 = 1 Then
        list_disp = MKR_LIST_OFF
        Call trk_0deg_mkr_display(pic, GrphRect, list_disp, s2, buf1, buf2, buf3)
    End If
    
    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, buf1, buf2, buf3)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub


'************************************************************************
' Auto Scale calculation (Scale value is obtained from maximum and minimum values and then set.)
'    Argument ByRef mx As Double : Maximum value
'         ByRef mn As Double : Minimum value
'         ByRef scl As Scale_t : Scale setting
'************************************************************************
Public Sub auto_scale(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    If div < 0.00001 Then '0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.00001 '0.001
    Else
        div = div * 100000 '1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CDbl(divs) / 100000 '1000 '<-- Clear the multiplication by 1000.
    End If
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10

End Sub

'***********************************************************************************
' Scale Div Change
'    Function chg_unit_value() As Double
'    Argument ByVal dt As Single : Argument value is converted into the multiple in each unit.
'         ByRef unit_dt As Single :Index
'    Return value :
'***********************************************************************************
Private Function chg_unit_value(ByRef dt As Double, ByRef unit_dt As Double) As Double
    Dim d As Single

    d = dt
    unit_dt = Unit_s

    If d >= Unit_g Then
        d = dt * Multiple_g
        unit_dt = Unit_g
    ElseIf d >= Unit_mega Then
        d = dt * Multiple_mega
        unit_dt = Unit_mega
    ElseIf d >= Unit_k Then
        d = dt * Multiple_k
        unit_dt = Unit_k
    ElseIf d >= Unit_s Then
        d = dt
        unit_dt = Unit_s
    ElseIf d >= Unit_m Then
        d = dt * Multiple_m
        unit_dt = Unit_m
    ElseIf d >= Unit_u Then
        d = dt * Multiple_u
        unit_dt = Unit_u
    ElseIf d >= Unit_n Then
        d = dt * Multiple_n
        unit_dt = Unit_n
    ElseIf d >= Unit_p Then
        d = dt * Multiple_p
        unit_dt = Unit_p
    ElseIf d >= Unit_f Then
        d = dt * Multiple_f
        unit_dt = Unit_f
    End If

    chg_unit_value = d

End Function
    
'************************************************************************
' Auto Scale calculation (Scale value is obtained from maximum and minimum values and then set.)
'    Argument ByRef mx As Double : Maximum value
'         ByRef mn As Double : Minimum value
'         ByRef scl As Scale_t : Scale setting
'************************************************************************
Public Sub auto_scale2(ByRef mx As Double, ByRef mn As Double, ByRef scl As Scale_t)
    Dim unit_dt As Double
    Dim div As Double
    Dim divs As String
    Dim head As String
    Dim rfv As Double

    div = (mx - mn) / 9
    div = chg_unit_value(div, unit_dt)
    If div < 0.001 Then '=== Does not perform scaling when value is less than 0.001 ===
        div = 0.001
    Else
        div = div * 1000 '<-- Multiply the value by 1000 temporarily.
        divs = CStr(div)
        If CDbl(Mid(divs, 2)) > 0 Then 'When the second and subsequent digits are other than 0.
            divs = CStr(CDbl(divs) - CDbl(Mid(divs, 2))) 'Clear the second and subsequent digits from the beginning to 0.
            divs = (CDbl(Mid(divs, 1, 1)) + 1) & Mid(divs, 2) 'Round-up the first digit.
        End If
        head = Mid(divs, 1, 1) 'Take out the first character.
        If CDbl(head) > 5 Then '--- Convert the value to 1/2/5 step. ---
            head = "10" '        V
        ElseIf CDbl(head) > 2 Then  '        V
            head = "5" '        V
        ElseIf CDbl(head) > 1 Then  '        V
            head = "2" '        V
        End If '        V
        divs = head & Mid(divs, 2)
        div = CSng(divs) / 1000 '<-- Clear the multiplication by 1000.
    End If
    div = div * unit_dt
    scl.div = div
    rfv = CSng(CLng((mx + mn) / 2 / div)) * div
    scl.ref = rfv + ((scl.pos - 50) * div) / 10
End Sub

'***********************************************************************************
' Marker display conversion (POLAR & Smith)
'    Function SclLimP() As Single
'    Argument ByVal c As Single : Reference point
'         ByRef R As Single : Ratio in the drawing direction
'         ByRef dt As Single : Display data
'
'    Return value : Display position
'***********************************************************************************
Public Function SclLimP(ByRef c As Single, ByRef R As Single, ByRef dt As Single) As Single
    Dim tmp As Single

    tmp = dt
    If 1 < tmp Then tmp = 1
    If tmp < -1 Then tmp = -1
    SclLimP = c + (tmp * R)

End Function


'***********************************************************************************
' Arrow marker display (POLAR & Smith)
'    Sub Arw_mkr_display()
'    Argument ByVal g As Graphics : Object of the graph display
'         ByRef CenX As Single : Central coordinate display area (X)
'         ByRef CenY As Single : Central coordinate display area (Y)
'         ByRef HanX As Single : X direction (radius of circle)
'         ByRef HanY As Single : Y direction (radius of circle)
'         ByRef re As Single : Real value of marker position
'         ByRef im As Single : Imag value of marker position
'***********************************************************************************
Public Sub Arw_mkr_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_Circle_coordinate, _
                    ByRef re() As Single, ByRef im() As Single)
    Dim xx As Single
    Dim yy As Single
    Dim StrMeasData As String
    Dim k As Integer
    Dim Y_line As Single
    Dim line_cnt As Integer
    Dim Color As Long
    Dim mp As Integer
    Dim mkr_frq As Double
    '
    Y_line = 150    ' 1 Line Offset
    line_cnt = 1
    
    With GrphCircle
        For k = 0 To MAX_MARKER
            mp = -1
            If Marker(BdId, ActCh(BdId), k).MkrDispFlag = MKR_DISPLAY Then
                mp = Marker(BdId, ActCh(BdId), k).MkrPoint
                If k = ActMkr Then
                    Color = MkrColor(MKR_COLOR___ACT)
                Else
                    Color = MkrColor(MKR_COLOR_NOACT)
                End If
            End If
            
            If mp >= 0 Then
                mkr_frq = Marker(BdId, ActCh(BdId), k).MkrFreq
                If BufFrq(mp) = mkr_frq Then
                    xx = SclLimP(.CenX, .HanX, re(mp))
                    yy = SclLimP(.CenY, -.HanY, im(mp))
                Else
                    If mp <> 0 Then
                        If BufFrq(mp - 1) < mkr_frq And mkr_frq < BufFrq(mp) Then
                            mp = mp - 1
                        ElseIf BufFrq(mp) < mkr_frq And mkr_frq < BufFrq(mp - 1) Then
                            mp = mp - 1
                        End If
                    End If
                    If BufFrq(mp + 1) = BufFrq(mp) Then
                        yy = im(mp) + (im(mp + 1) - im(mp))
                        xx = re(mp) + (re(mp + 1) - re(mp))
                    Else
                        yy = im(mp) + (mkr_frq - BufFrq(mp)) * ((im(mp + 1) - im(mp)) / (BufFrq(mp + 1) - BufFrq(mp)))
                        xx = re(mp) + (mkr_frq - BufFrq(mp)) * (re(mp + 1) - re(mp)) / (BufFrq(mp + 1) - BufFrq(mp))
                    End If
                    xx = SclLimP(.CenX, .HanX, xx)
                    yy = SclLimP(.CenY, -.HanY, yy)
                End If
                
                Call grph_mkr_mark_disp(pic, xx, yy, CStr(k + 1), Color) 'Marker display
                
            End If
        Next k
    End With
    
End Sub




'***********************************************************************************
' Waveform display (POLAR)
'    Sub waveformP_display()
'    Argument ByRef pic As PictureBox : Object of the graph display
'         ByRef ViewX As Single : Display area (X)
'         ByRef ViewY As Single : Display area (Y)
'         ByRef VYoff As Single : Offset in Y direction
'         ByRef Scale As Scale_t : Scale value displayed
'         ByRef points As Integer : Number of measurement points
'         ByVal Color As Long    : Waveform color
'         ByRef real() As Single : Array data of Real value
'         ByRef imag() As Single : Array data of Imag value
'***********************************************************************************
Private Sub waveformP_display(ByRef pic As PictureBox, GrphCircle As struct_Circle_coordinate, _
                                ByVal Color As Long, ByRef real() As Single, ByRef imag() As Single)
    Dim Ydata1, Xdata1 As Single
    Dim po As Integer
    
    On Error GoTo ErrReImOverflow

    '----------------------------------
    ' POLAR waveform display
    '----------------------------------
    With GrphCircle
        Xdata1 = SclLimP(.CenX, .HanX, real(0))
        Ydata1 = SclLimP(.CenY, -.HanY, imag(0))
    
        pic.PSet (Xdata1, Ydata1)
    
        For po = 0 To .points
          Xdata1 = SclLimP(.CenX, .HanX, real(po))
          Ydata1 = SclLimP(.CenY, -.HanY, imag(po))
          pic.Line -(Xdata1, Ydata1), Color
        Next po
    
ErrReImEnd:
    End With
    On Error GoTo 0
    Exit Sub

ErrReImOverflow:
    MsgBox "Error Re/Im Data Overflow" + vbCrLf + vbCrLf, vbOKOnly Or vbCritical
    GoTo ErrReImEnd

End Sub


'***********************************************************************************
' Grid display (POLAR)
'    Sub gridP_display()
'    Argument ByVal g As Graphics : Object of the graph display
'         ByRef CenX As Single : Central coordinate for display area (X)
'         ByRef CenY As Single : Central coordinate for display area (Y)
'         ByRef HanX As Single : X direction (radius of circle)
'         ByRef HanY As Single : Y direction (radius of circle)
'         ByVal Color1 As Long    : Grid color
'         ByVal Color2 As Long    : Grid color
'***********************************************************************************
Private Sub gridP_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_Circle_coordinate)
    
    pic.DrawStyle = 0  'Solid line specification

    '----------------------------------
    ' Grid display
    '----------------------------------
    With GrphCircle
        pic.PSet (.CenX - .HanX, .CenY)
        pic.Line -(.CenX + .HanX, .CenY), .Color1
        pic.PSet (.CenX, .CenY - .HanY)
        pic.Line -(.CenX, .CenY + .HanY), .Color1
        pic.Circle (.CenX, .CenY), .HanY, .Color1
    
        pic.Circle (.CenX, .CenY), .HanY * 0.2, .Color2
        pic.Circle (.CenX, .CenY), .HanY * 0.4, .Color2
        pic.Circle (.CenX, .CenY), .HanY * 0.6, .Color2
        pic.Circle (.CenX, .CenY), .HanY * 0.8, .Color2
    End With
    
End Sub

'**********************************************
Private Sub draw_circle_grid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphCircle As struct_Circle_coordinate, _
                        ByRef Color() As Long) 'ByVal Color1 As Long, ByVal Color2 As Long)
    
    'Calculates size of scale frame
    With GrphCircle
        .points = pt - 1
        .ViewX = pic.ScaleWidth / 12
        .ViewY = pic.ScaleHeight / 12
        .HanY = .ViewY * 5: .HanX = .HanY
        .CenX = .ViewX * 6 - CENTER_OFFSET
        .CenY = .ViewY * 6 * GRAPH_Y_RATIO
        .Color1 = Color(GRID_NORMAL)
        .Color2 = Color(GRID_BOLD)
    End With
    

End Sub

Private Sub draw_circle_Pgrid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphCircle As struct_Circle_coordinate, _
                        ByRef Color() As Long)
                        
    Call draw_circle_grid(pic, pt, GrphCircle, Color)
    '----------------------------------
    ' Circle grid display
    '----------------------------------
    Call gridP_display(pic, GrphCircle)
                        
End Sub

Private Sub draw_circle_Sgrid(ByRef pic As PictureBox, ByRef pt As Long, ByRef GrphCircle As struct_Circle_coordinate, _
                        ByRef Color() As Long)
                        
    Call draw_circle_grid(pic, pt, GrphCircle, Color)
    '----------------------------------
    ' Circle grid display
    '----------------------------------
    Call gridS_display(pic, GrphCircle)
                        
End Sub

'************************************************************************
' Waveform and marker display (POLAR)
'    Sub draw_waveP_Mem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef real() As Single : Array data of Real value
'         ByRef imag() As Single : Array data of Imag value
'         ByRef real_Pre() As Single : For the previous data to draw waveforms (Real value).
'         ByRef imag_Pre() As Single : For the previous data to draw waveforms (Imag value).
'         ByRef pt As Integer : Number of measurement points
'         ByRef mk As Short F Marker drawing flag
'         ByRef mp As Short F Marker position (point value)
'         ByRef mp_Pre As Short F Previous marker position (point value)
'************************************************************************
Public Sub draw_waveP_Mem(ByRef pic As PictureBox, _
                ByRef real() As Single, ByRef imag() As Single, ByRef Data() As Single, _
                ByRef pt As Long, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByRef mk As Integer)
    Dim points As Integer
    Dim ViewX, ViewY As Single
    Dim CenX, CenY, HanX, HanY As Single
    Dim im, re As Single
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphCircle As struct_Circle_coordinate
    Dim list_disp As Integer
    
    points = pt - 1

    'Calculates size of scale frame
    ViewX = pic.ScaleWidth / 12
    ViewY = pic.ScaleHeight / 12
    pic.DrawStyle = 0  'Solid line specification

    HanY = ViewY * 5: HanX = HanY
    CenX = ViewX * 6 - CENTER_OFFSET
    CenY = ViewY * 6 * GRAPH_Y_RATIO
    line_cnt = 1: cntup = 1

    pic.Cls
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_circle_Pgrid(pic, pt, GrphCircle, GrdClrPolar)

    '----------------------------------
    ' POLAR waveform display
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveformP_display(pic, GrphCircle, .MemTrcPolarCol, .MemTrcBufReal, .MemTrcBufImag)
                End With
            End If
        Next tr
    End If
    Call waveformP_display(pic, GrphCircle, TrcClrPolar, real, imag)

    '----------------------------------
    ' Drawing the current marker position
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call Arw_mkr_display(pic, GrphCircle, .MemTrcBufReal, .MemTrcBufImag)
            End With
        End If
        Call Arw_mkr_display(pic, GrphCircle, real, imag)
    End If

    Call Arw_trk_mkr_display(pic, GrphCircle, list_disp, real, imag, Data)
    
    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, BufLgm, BufPhs, Data)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub

'***********************************************************************************
' Grid display (Smith)
'    Sub gridS_display()
'    Argument ByVal g As Graphics : Object of the graph display
'         ByRef CenX As Single : Display area central coordinate (X)
'         ByRef CenY As Single : Display area central coordinate (Y)
'         ByRef R As Single : Radius (R) of circle (circumference) drawing the grid
'         ByVal Color1 As Long    : Grid Horizontal Reactance axis color
'         ByVal Color2 As Long    : Grid Inner circle color
'***********************************************************************************
Private Sub gridS_display(ByRef pic As PictureBox, ByRef GrphCircle As struct_Circle_coordinate)
    Dim x1, y1, x2, y2 As Single
    Dim i As Integer
    Dim grid_circle_r(5) As Single  'Scale value of resistance
    Dim grid_circle_x(5) As Single 'Scale value of reactance
    Dim grid_circle_st(5) As Single 'Start angle of reactance arc
    Dim grid_circle_sp(5) As Single 'End angle of reactance arc

    grid_circle_r(0) = 0.2: grid_circle_r(1) = 0.5: grid_circle_r(2) = 1: grid_circle_r(3) = 2: grid_circle_r(4) = 5 'Scale value of resistance
    grid_circle_x(0) = 0.2: grid_circle_x(1) = 0.5: grid_circle_x(2) = 1: grid_circle_x(3) = 2: grid_circle_x(4) = 5 'cale value of reactance
    grid_circle_st(0) = 90#: grid_circle_st(1) = 90#: grid_circle_st(2) = 90#: grid_circle_st(3) = 90#: grid_circle_st(4) = 90# 'Start angle of reactance arc
    grid_circle_sp(0) = 22.6198654: grid_circle_sp(1) = 53.13008:  grid_circle_sp(2) = 89.7: grid_circle_sp(3) = 126.869845: grid_circle_sp(4) = 157.379975 'End angle of reactance arc
    
    pic.DrawStyle = 0  'Solid line specification

    '----------------------------------
    ' Grid display
    '----------------------------------
    'Horizontal axis
    With GrphCircle
        pic.PSet (.CenX - .HanX, .CenY)
        pic.Line -(.CenX + .HanX, .CenY), .Color1
        pic.PSet (.CenX, .CenY)
        pic.Circle (.CenX, .CenY), .HanX, .Color1
        
        'Inner circle (resistance)
        For i = 0 To 4
            x2 = .HanX * (1 / (1 + grid_circle_r(i)))
            y2 = x2
            x1 = .CenX + .HanX - x2
            y1 = .CenY - y2 * 0.5
            pic.Circle (x1, .CenY), x2, .Color2
        Next
        
        'Reactance
        For i = 0 To 4
            x2 = .HanX * (1 / grid_circle_x(i))
            y2 = x2
            y1 = .CenY - y2
            pic.Circle (.CenX + .HanX, y1), x2, .Color1, (270 - grid_circle_sp(i)) * pi / 180, 270 * pi / 180
    
            y1 = .CenY + y2
            pic.Circle (.CenX + .HanX, y1), x2, .Color1, 90 * pi / 180, (90 + grid_circle_sp(i)) * pi / 180
        Next
    End With
    
End Sub

'************************************************************************
' Waveform and marker display (Smith)
'    Sub draw_waveS_Mem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef real() As Single : Array data of Real value
'         ByRef imag() As Single : Array data of Imag value
'         ByRef real_Pre() As Single : For the previous data to draw waveforms (Real value).
'         ByRef imag_Pre() As Single : For the previous data to draw waveforms (Imag value).
'         ByRef pt As Integer : Number of measurement points
'         ByRef mk As Short F Marker drawing flag
'************************************************************************
Public Sub draw_waveS_Mem(ByRef pic As PictureBox, _
                ByRef real() As Single, ByRef imag() As Single, ByRef Data() As Single, _
                ByVal pt As Long, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByVal mk As Integer)
    Dim points As Integer
    Dim ViewX, ViewY As Single
    Dim CenX, CenY, HanX, HanY As Single
    Dim im, re As Single
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphCircle As struct_Circle_coordinate
    Dim list_disp As Integer

    points = pt - 1

    'Calculates size of scale frame
    ViewX = pic.ScaleWidth / 12
    ViewY = pic.ScaleHeight / 12
    pic.DrawStyle = 0  'Solid line specification

    HanY = ViewY * 5: HanX = HanY
    CenX = ViewX * 6 - CENTER_OFFSET
    CenY = ViewY * 6 * GRAPH_Y_RATIO
    line_cnt = 1: cntup = 1

    pic.Cls
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_circle_Sgrid(pic, pt, GrphCircle, GrdClrSmith)
    
    '----------------------------------
    ' Smith waveform display
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveformP_display(pic, GrphCircle, .MemTrcSmithCol, .MemTrcBufReal, .MemTrcBufImag)
                End With
            End If
        Next tr
    End If
    Call waveformP_display(pic, GrphCircle, TrcClrSmith, real, imag)

    '----------------------------------
    ' Drawing current marker position
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call Arw_mkr_display(pic, GrphCircle, .MemTrcBufReal, .MemTrcBufImag)
            End With
        End If
        Call Arw_mkr_display(pic, GrphCircle, real, imag)
    End If
    
    Call Arw_trk_mkr_display(pic, GrphCircle, list_disp, real, imag, Data)
    
    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, real, imag, Data)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub

'***********************************************************************************
' Waveform and marker display (DELAY)
'    Sub draw_waveD_Mem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef buf1() As Single : Array data of Delay value
'         ByRef pt As Integer : Number of measurement points
'         ByRef s1 As Scale_t : Scale value for LogMag
'         ByRef mk As Short F Marker drawing flag
'         ByRef mp As Short F Marker position (point value)
'***********************************************************************************
Public Sub draw_waveD_Mem(ByRef pic As PictureBox, _
                ByRef buf1() As Single, ByRef buf2() As Single, ByRef buf3() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByRef mk As Integer)
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim list_disp As Integer

    line_cnt = 1: cntup = 1
    
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_grid(pic, pt, GrphRect, GrdClrDelay)

    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, GrphRect, s1, TrcClrDelay)   ' DELAY

    '----------------------------------
    ' DELAY waveform
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveform_display(pic, GrphRect, s1, .MemTrcDelayCol, .MemTrcBufDelay)
                End With
            End If
        Next tr
    End If
    Call waveform_display(pic, GrphRect, s1, TrcClrDelay, buf1)

    '----------------------------------
    ' Drawing current marker
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call v_mkr_display(pic, GrphRect, s1, .MemTrcBufDelay)
            End With
        End If
        Call v_mkr_display(pic, GrphRect, s1, buf1)
    End If

    Call trk_mkr_display(pic, GrphRect, list_disp, s1, buf1, buf2, buf3)

    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, buf1, buf2, buf3)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufDelay(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub


'***********************************************************************************
' Waveform and marker display (SWR)
'    Sub draw_waveSwrMem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef buf1() As Single : Array data of VSWR value
'         ByRef pt As Integer : Number of measurement points
'         ByRef s1 As Scale_t : Scale value for LogMag
'         ByRef mk As Short F Marker drawing flag
'***********************************************************************************
Public Sub draw_waveSwrMem(ByRef pic As PictureBox, _
                ByRef buf1() As Single, ByRef buf2() As Single, ByRef buf3() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByRef mk As Integer)
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim list_disp As Integer

    line_cnt = 1: cntup = 1

    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_grid(pic, pt, GrphRect, GrdClrSwr)

    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, GrphRect, s1, TrcClrSwr)   ' SWR

    '----------------------------------
    ' SWR waveform
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveform_display(pic, GrphRect, s1, .MemTrcSwrCol, .MemTrcBufSwr)
                End With
            End If
        Next tr
    End If
    Call waveform_display(pic, GrphRect, s1, TrcClrSwr, buf1)

    '----------------------------------
    ' Drawing current marker
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call v_mkr_display(pic, GrphRect, s1, .MemTrcBufSwr)
            End With
        End If
        Call v_mkr_display(pic, GrphRect, s1, buf1)
    End If

    Call trk_mkr_display(pic, GrphRect, list_disp, s1, buf1, buf2, buf3)
    
    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, BufLgm, buf2, buf3)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub


'***********************************************************************************
' Waveform and marker display
'    Sub draw_waveRealMem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef buf1() As Single : Array data of Real or Imag value
'         ByRef pt As Integer : Number of measurement points
'         ByRef s1 As Scale_t : Scale value for Real or Imag
'         ByRef mk As Integer F Marker drawing flag
'         ByRef mp As Integer F Marker position (point value)
'***********************************************************************************
Public Sub draw_waveRealMem(ByRef pic As PictureBox, _
                ByRef buf1() As Single, ByRef buf2() As Single, ByRef buf3() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByRef mk As Integer, _
                ByVal ref_color As Long, _
                ByVal wv_color As Long)
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim list_disp As Integer
    
    line_cnt = 1: cntup = 1

    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_grid(pic, pt, GrphRect, GrdClrReal)
    
    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, GrphRect, s1, ref_color)   ' Real

    '----------------------------------
    ' Real waveform
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveform_display(pic, GrphRect, s1, .MemTrcRealCol, .MemTrcBufReal)
                End With
            End If
        Next tr
    End If
    Call waveform_display(pic, GrphRect, s1, wv_color, buf1)

    '----------------------------------
    ' Drawing current marker
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call v_mkr_display(pic, GrphRect, s1, .MemTrcBufReal)
            End With
        End If
        Call v_mkr_display(pic, GrphRect, s1, buf1)
    End If

    Call trk_mkr_display(pic, GrphRect, list_disp, s1, buf1, buf2, buf3)

    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, BufLgm, buf2, buf1)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub

'***********************************************************************************
' Waveform and marker display
'    Sub draw_waveImagMem()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'         ByRef buf1() As Single : Array data of Real or Imag value
'         ByRef pt As Integer : Number of measurement points
'         ByRef s1 As Scale_t : Scale value for Real or Imag
'         ByRef mk As Integer F Marker drawing flag
'         ByRef mp As Integer F Marker position (point value)
'***********************************************************************************
Public Sub draw_waveImagMem(ByRef pic As PictureBox, _
                ByRef buf1() As Single, ByRef buf2() As Single, ByRef buf3() As Single, _
                ByRef pt As Long, _
                ByRef s1 As Scale_t, _
                ByRef ChMemTrc() As structMemTraceChInf, _
                ByRef MemTrc() As structMemTrcInf, _
                ByRef mk As Integer, _
                ByVal ref_color As Long, _
                ByVal wv_color As Long)
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim list_disp As Integer

    line_cnt = 1: cntup = 1
    
    '----------------------------------
    ' Grid display
    '----------------------------------
    Call draw_grid(pic, pt, GrphRect, GrdClrImag)
    
    '----------------------------------
    'Reference mark  display
    '----------------------------------
    Call ref_mkr_display(pic, GrphRect, s1, ref_color)   ' Imag

    '----------------------------------
    ' Imag waveform
    '----------------------------------
    If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
        For tr = 0 To MAX_MEMTRACE
            If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                With ChMemTrc(BdId, ActCh(BdId), tr)
                    Call waveform_display(pic, GrphRect, s1, .MemTrcImagCol, .MemTrcBufImag)
                End With
            End If
        Next tr
    End If
    Call waveform_display(pic, GrphRect, s1, wv_color, buf1)
    
    '----------------------------------
    ' Drawing current marker
    '----------------------------------
    If mk = 1 Then
        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
            With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                Call v_mkr_display(pic, GrphRect, s1, .MemTrcBufImag)
            End With
        End If
        Call v_mkr_display(pic, GrphRect, s1, buf1)
    End If

    Call trk_mkr_display(pic, GrphRect, list_disp, s1, buf1, buf2, buf3)

    Call mkr_list_display(pic, MEM_TRC_DSP_OFF, line_cnt, cntup, BufLgm, buf2, buf1)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            Call mkr_list_display(pic, MTrcDspFlg, line_cnt, cntup, _
                                    .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
        End With
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub

Public Sub mkr_list_Overla(ByRef pic As PictureBox, ByVal MemTrace As Integer, ByVal fmt_type As Integer, ByVal line_cnt As Integer, ByVal cntup As Integer)
    
    If MemTrace = MEM_TRC_DSP_OFF Then
        If fmt_type = FmtTypeLogMg Or fmt_type = FmtTypePolar Then
            Call mkr_list_display(pic, MemTrace, line_cnt, cntup, BufLgm(), BufPhs(), BufLnm())
        ElseIf fmt_type = FmtTypeSmith Then
            Call mkr_list_display(pic, MemTrace, line_cnt, cntup, BufReal(), BufImag(), BufLnm())
        ElseIf fmt_type = FmtTypeDelay Then
            Call mkr_list_display(pic, MemTrace, line_cnt, cntup, BufDelay(), BufPhs(), BufLnm())
        ElseIf fmt_type = FmtTypeSwr Then
            Call mkr_list_display(pic, MemTrace, line_cnt, cntup, BufLnm(), BufPhs(), BufLnm())
        ElseIf fmt_type = FmtTypeReal Then
            Call mkr_list_display(pic, MemTrace, line_cnt, cntup, BufReal(), BufPhs(), BufLnm())
        ElseIf fmt_type = FmtTypeImag Then
            Call mkr_list_display(pic, MemTrace, line_cnt, cntup, BufImag(), BufPhs(), BufLnm())
        End If
    Else
        With ChMemTrcInf(BdId, ActCh(BdId), ActMemTrc)
            If fmt_type = FmtTypeLogMg Or fmt_type = FmtTypePolar Then
                Call mkr_list_display(pic, MemTrace, line_cnt, cntup, .MemTrcBufLgm(), .MemTrcBufPhs(), .MemTrcBufLnm())
            ElseIf fmt_type = FmtTypeSmith Then
                Call mkr_list_display(pic, MemTrace, line_cnt, cntup, .MemTrcBufReal(), .MemTrcBufImag(), .MemTrcBufLnm())
            ElseIf fmt_type = FmtTypeDelay Then
                Call mkr_list_display(pic, MemTrace, line_cnt, cntup, .MemTrcBufDelay(), .MemTrcBufPhs(), .MemTrcBufLnm())
            ElseIf fmt_type = FmtTypeSwr Then
                Call mkr_list_display(pic, MemTrace, line_cnt, cntup, .MemTrcBufLnm(), .MemTrcBufPhs(), .MemTrcBufLnm())
            ElseIf fmt_type = FmtTypeReal Then
                Call mkr_list_display(pic, MemTrace, line_cnt, cntup, .MemTrcBufReal(), .MemTrcBufPhs(), .MemTrcBufLnm())
            ElseIf fmt_type = FmtTypeImag Then
                Call mkr_list_display(pic, MemTrace, line_cnt, cntup, .MemTrcBufImag(), .MemTrcBufPhs(), .MemTrcBufLnm())
            End If
        End With
    End If
End Sub

'***********************************************************************************
' Waveform and marker display  (Overlap)
'    Sub draw_waveO()
'    Argument ByRef pic As System.Windows.Forms.PictureBox :
'***********************************************************************************
Public Sub draw_waveO(ByRef pic As PictureBox, ByRef ChMemTrc() As structMemTraceChInf, ByRef MemTrc() As structMemTrcInf)
    Dim ViewPS_Y, ViewPS_X As Single
    Dim CenX, CenY, HanX, HanY As Single
    Dim points As Integer
    Dim mp As Integer
    Dim wave_disp As Integer
    Dim scl As Scale_t
    Dim tr As Integer
    Dim line_cnt As Integer
    Dim cntup As Integer
    Dim MTrcDspFlg As Integer
    Dim GrphRect As struct_Rectangular_coordinate
    Dim GrphCircle As struct_Circle_coordinate
    Dim trk_dsp As Integer
    Dim list_disp As Integer
    Dim total_disp As Integer

    wave_disp = 0
    With frmMain
        points = totalP - 1
        mp = Marker(BdId, ActCh(BdId), ActMkr).MkrPoint
        line_cnt = 1: cntup = 1
        
        pic.Cls
        If .Check_Format(ChkTypeLogMg).Value = 1 Or .Check_Format(ChkTypeDelay).Value = 1 Or .Check_Format(ChkTypeSwr).Value = 1 _
            Or .Check_Format(ChkTypeReal).Value = 1 Or .Check_Format(ChkTypeImag).Value = 1 Then
            '---------------------------------------------------------------
            ' LOGMAG and PHASE or DELAY or SWR or REAL or IMAG Grid display
            '---------------------------------------------------------------
            'Calculates size of scale frame
            Call draw_grid(pic, totalP, GrphRect, GrdClrLogmag)
        End If
    
        If .Check_Format(ChkTypePolar).Value = 1 Or .Check_Format(ChkTypeSmith).Value = 1 Then
            '-----------------------------
            ' POLAR or Smith Grid display
            '-----------------------------
            'Calculates size of scale frame
            ViewPS_X = pic.ScaleWidth / 12
            ViewPS_Y = pic.ScaleHeight / 12
            pic.DrawStyle = 0  'Solid line specification
            HanY = ViewPS_Y * 5: HanX = HanY
            CenX = ViewPS_X * 6 - CENTER_OFFSET
            CenY = ViewPS_Y * 6 * GRAPH_Y_RATIO
            If .Check_Format(ChkTypePolar).Value = 1 Then Call draw_circle_Pgrid(pic, totalP, GrphCircle, GrdClrPolar)
            If .Check_Format(ChkTypeSmith).Value = 1 Then Call draw_circle_Sgrid(pic, totalP, GrphCircle, GrdClrSmith)
            wave_disp = 1
         End If
       
        If .Check_Format(ChkTypeLogMg).Value = 1 Then
            '--------------------------------------------
            ' LOGMAG and PHASE Reference mark  display
            '--------------------------------------------
            Call ref_mkr_display(pic, GrphRect, Mscl(BdId, ActCh(BdId)), TrcClrLogmag)   ' Lognmag
            Call ref_mkr_display(pic, GrphRect, Pscl(BdId, ActCh(BdId)), TrcClrPhase)    ' Phase

            '----------------------------------
            ' LOGMAG and PHASE waveform
            '----------------------------------
            scl = Mscl(BdId, ActCh(BdId))
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveform_display(pic, GrphRect, scl, .MemTrcLgmCol, .MemTrcBufLgm)
                        End With
                    End If
                Next tr
            End If
            Call waveform_display(pic, GrphRect, scl, TrcClrLogmag, BufLgm)
            
            If frmMain.Check_phs.Value = 1 Then
                scl = Pscl(BdId, ActCh(BdId))
                If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                    For tr = 0 To MAX_MEMTRACE
                        If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                            With ChMemTrc(BdId, ActCh(BdId), tr)
                                Call waveform_display(pic, GrphRect, scl, .MemTrcPhsCol, .MemTrcBufPhs)
                            End With
                        End If
                    Next tr
                End If
                Call waveform_display(pic, GrphRect, scl, TrcClrPhase, BufPhs)
            End If
            wave_disp = 1
        End If
        
        If .Check_Format(ChkTypeDelay).Value = 1 Then
            '----------------------------------
            ' DELAY Reference mark  display
            '----------------------------------
            Call ref_mkr_display(pic, GrphRect, Dscl(BdId, ActCh(BdId)), TrcClrDelay)
            '----------------------------------
            ' DELAY waveform
            '----------------------------------
            scl = Dscl(BdId, ActCh(BdId))
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveform_display(pic, GrphRect, scl, .MemTrcDelayCol, .MemTrcBufDelay)
                        End With
                    End If
                Next tr
            End If
            Call waveform_display(pic, GrphRect, scl, TrcClrDelay, BufDelay)
            wave_disp = 1
        End If
        
        If .Check_Format(ChkTypeSwr).Value = 1 Then
            '----------------------------------
            ' SWR Reference mark  display
            '----------------------------------
            Call ref_mkr_display(pic, GrphRect, SWRscl(BdId, ActCh(BdId)), TrcClrSwr)
            '----------------------------------
            ' SWR waveform
            '----------------------------------
            scl = SWRscl(BdId, ActCh(BdId))
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveform_display(pic, GrphRect, scl, .MemTrcSwrCol, .MemTrcBufSwr)
                        End With
                    End If
                Next tr
            End If
            Call waveform_display(pic, GrphRect, scl, TrcClrSwr, BufSwr)
            wave_disp = 1
        End If
        
        If .Check_Format(ChkTypeReal).Value = 1 Then
            '----------------------------------
            ' Real Reference mark  display
            '----------------------------------
            Call ref_mkr_display(pic, GrphRect, Rscl(BdId, ActCh(BdId)), TrcClrReal)
            '----------------------------------
            ' Real waveform
            '----------------------------------
            scl = Rscl(BdId, ActCh(BdId))
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveform_display(pic, GrphRect, scl, .MemTrcRealCol, .MemTrcBufReal)
                        End With
                    End If
                Next tr
            End If
            Call waveform_display(pic, GrphRect, scl, TrcClrReal, BufReal)
            wave_disp = 1
        End If
        
        If .Check_Format(ChkTypeImag).Value = 1 Then
            '----------------------------------
            ' Imag Reference mark  display
            '----------------------------------
            Call ref_mkr_display(pic, GrphRect, Iscl(BdId, ActCh(BdId)), TrcClrImag)
            '----------------------------------
            ' Imag waveform
            '----------------------------------
            scl = Iscl(BdId, ActCh(BdId))
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveform_display(pic, GrphRect, scl, .MemTrcImagCol, .MemTrcBufImag)
                        End With
                    End If
                Next tr
            End If
            Call waveform_display(pic, GrphRect, scl, TrcClrImag, BufImag)
            wave_disp = 1
        End If
        
        '----------------------------------
        ' POLAR waveform display
        '----------------------------------
        If .Check_Format(ChkTypePolar).Value = 1 Then
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveformP_display(pic, GrphCircle, .MemTrcPolarCol, .MemTrcBufReal, .MemTrcBufImag)
                        End With
                    End If
                Next tr
            End If
            Call waveformP_display(pic, GrphCircle, TrcClrPolar, BufReal, BufImag)
            wave_disp = 1
        End If
    
        '----------------------------------
        ' Smith waveform display
        '----------------------------------
        If .Check_Format(ChkTypeSmith).Value = 1 Then
            If MemTrc(BdId, ActCh(BdId)).MemTrcTotalDispFlag Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) = MEM_TRC_DSP_ON Then cntup = 2
                For tr = 0 To MAX_MEMTRACE
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(tr) Then
                        With ChMemTrc(BdId, ActCh(BdId), tr)
                            Call waveformP_display(pic, GrphCircle, .MemTrcSmithCol, .MemTrcBufReal, .MemTrcBufImag)
                        End With
                    End If
                Next tr
            End If
            Call waveformP_display(pic, GrphCircle, TrcClrSmith, BufReal, BufImag)
            wave_disp = 1
        End If
        
        '----------------------------------
        ' Drawing current marker
        '----------------------------------
        If .Check_mkr.Value = 1 Then
        
            If .Check_Format(ChkTypeLogMg).Value = 1 Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                    With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                        Call v_mkr_display(pic, GrphRect, Mscl(BdId, ActCh(BdId)), .MemTrcBufLgm)
                    End With
                End If
                Call v_mkr_display(pic, GrphRect, Mscl(BdId, ActCh(BdId)), BufLgm)
                
                If frmMain.Check_phs.Value = 1 Then
                    If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                        With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                            Call v_mkr_display(pic, GrphRect, Pscl(BdId, ActCh(BdId)), .MemTrcBufPhs)
                        End With
                    End If
                    Call v_mkr_display(pic, GrphRect, Pscl(BdId, ActCh(BdId)), BufPhs)
                End If
                Call trk_mkr_display(pic, GrphRect, list_disp, Mscl(BdId, ActCh(BdId)), BufLgm, BufPhs, BufLnm)
                If frmMain.Check_phs.Value = 1 Then
                    list_disp = MKR_LIST_OFF
                    Call trk_0deg_mkr_display(pic, GrphRect, list_disp, Pscl(BdId, ActCh(BdId)), BufLgm, BufPhs, BufLnm)
                End If
            End If
            
            If .Check_Format(ChkTypeDelay).Value = 1 Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                    With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                        Call v_mkr_display(pic, GrphRect, Dscl(BdId, ActCh(BdId)), .MemTrcBufDelay)
                    End With
                End If
                Call v_mkr_display(pic, GrphRect, Dscl(BdId, ActCh(BdId)), BufDelay)
                Call trk_mkr_display(pic, GrphRect, list_disp, Dscl(BdId, ActCh(BdId)), BufDelay, BufPhs, BufLnm)
            End If
            
            If .Check_Format(ChkTypeSwr).Value = 1 Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                    With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                        Call v_mkr_display(pic, GrphRect, SWRscl(BdId, ActCh(BdId)), .MemTrcBufSwr)
                    End With
                End If
                Call v_mkr_display(pic, GrphRect, SWRscl(BdId, ActCh(BdId)), BufSwr)
                Call trk_mkr_display(pic, GrphRect, list_disp, SWRscl(BdId, ActCh(BdId)), BufSwr, BufPhs, BufLnm)
            End If
            
            If .Check_Format(ChkTypeReal).Value = 1 Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                    With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                        Call v_mkr_display(pic, GrphRect, Rscl(BdId, ActCh(BdId)), .MemTrcBufReal)
                    End With
                End If
                Call v_mkr_display(pic, GrphRect, Rscl(BdId, ActCh(BdId)), BufReal)
                Call trk_mkr_display(pic, GrphRect, list_disp, Rscl(BdId, ActCh(BdId)), BufReal, BufPhs, BufLnm)
            End If
            
            If .Check_Format(ChkTypeImag).Value = 1 Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                    With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                        Call v_mkr_display(pic, GrphRect, Iscl(BdId, ActCh(BdId)), .MemTrcBufImag)
                    End With
                End If
                Call v_mkr_display(pic, GrphRect, Iscl(BdId, ActCh(BdId)), BufImag)
                Call trk_mkr_display(pic, GrphRect, list_disp, Iscl(BdId, ActCh(BdId)), BufImag, BufPhs, BufLnm)
            End If

            If wave_disp Then
                If MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc) Then
                    With ChMemTrc(BdId, ActCh(BdId), ActMemTrc)
                        Call Arw_mkr_display(pic, GrphCircle, .MemTrcBufReal, .MemTrcBufImag)
                    End With
                End If
                Call Arw_mkr_display(pic, GrphCircle, BufReal, BufImag)
                Call Arw_trk_mkr_display(pic, GrphCircle, list_disp, BufReal, BufImag, BufLnm)
            End If
        End If
        
    End With
    
    Call mkr_list_Overla(pic, MEM_TRC_DSP_OFF, frmMain.Combo_MkrActFormat.ListIndex, line_cnt, cntup)
    line_cnt = 2: MTrcDspFlg = MemTrc(BdId, ActCh(BdId)).MemTrcDispFlag(ActMemTrc)
    If MTrcDspFlg = MEM_TRC_DSP_ON Then
        Call mkr_list_Overla(pic, MTrcDspFlg, frmMain.Combo_MkrActFormat.ListIndex, line_cnt, cntup)
    End If
    
    If intFileSave = cnt_FILE_SAVING Then Call disp_message(pic, WAIT_MESSAGE_01)
End Sub



